/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.world.generate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.jayjay.dangerzone.block.Blocks;
import net.jayjay.dangerzone.client.DZ2;
import net.jayjay.dangerzone.utils.RNG;
import net.jayjay.dangerzone.world.World;
import net.jayjay.dangerzone.world.chunk.WorldChunk;
import net.jayjay.dangerzone.world.generate.BiomeType;
import net.jayjay.dangerzone.world.generate.FlowerConfig;
import net.jayjay.dangerzone.world.generate.GreatTreeConfig;
import net.jayjay.dangerzone.world.generate.OreConfig;
import net.jayjay.dangerzone.world.generate.TreeConfig;
import net.jayjay.dangerzone.world.generate.WorldGenerator;
import net.jayjay.dangerzone.world.noise.PerlinNoiseGenerator;

public class DZ2WorldGenerator
extends WorldGenerator {
    private static final int SEA_LEVEL = 64;
    private PerlinNoiseGenerator terrainNoise = null;
    private PerlinNoiseGenerator detailNoise = null;
    private PerlinNoiseGenerator caveNoise = null;
    private PerlinNoiseGenerator cloudNoise = null;
    private PerlinNoiseGenerator treeNoise = null;
    private PerlinNoiseGenerator tallGrassNoise = null;
    private PerlinNoiseGenerator flowerNoise = null;
    private final BiomeType biomeType;
    public static List<OreConfig> oreConfigs = new ArrayList<OreConfig>(Arrays.asList(new OreConfig(Blocks.getBlockID("dz2:ruby_ore"), 0.5, 0.015, 2, 4), new OreConfig(Blocks.getBlockID("dz2:mese_ore"), 0.6, 0.02, 2, 4), new OreConfig(Blocks.getBlockID("dz2:iron_ore"), 0.7, 0.025, 3, 6), new OreConfig(Blocks.getBlockID("dz2:copper_ore"), 0.65, 0.035, 4, 8)));
    public static List<FlowerConfig> flowerConfigs = new ArrayList<FlowerConfig>(Arrays.asList(new FlowerConfig[0]));
    public static List<TreeConfig> treeConfigs = new ArrayList<TreeConfig>(Arrays.asList(new TreeConfig[0]));
    public static List<GreatTreeConfig> greatTreeConfigs = new ArrayList<GreatTreeConfig>(Arrays.asList(new GreatTreeConfig[0]));
    int a = 0;
    int yC = 0;

    public DZ2WorldGenerator(World world, long worldSeed, BiomeType forcedBiome) {
        super(world, worldSeed, forcedBiome);
        Random random = new Random(worldSeed);
        this.terrainNoise = new PerlinNoiseGenerator(random);
        this.detailNoise = new PerlinNoiseGenerator(new Random(random.nextLong()));
        this.caveNoise = new PerlinNoiseGenerator(new Random(random.nextLong()));
        this.cloudNoise = new PerlinNoiseGenerator(new Random(random.nextLong()));
        this.treeNoise = new PerlinNoiseGenerator(new Random(random.nextLong()));
        this.tallGrassNoise = new PerlinNoiseGenerator(new Random(random.nextLong()));
        this.flowerNoise = new PerlinNoiseGenerator(new Random(random.nextLong()));
        if (forcedBiome != null) {
            this.biomeType = forcedBiome;
        } else {
            BiomeType[] biomes = BiomeType.values();
            this.biomeType = biomes[random.nextInt(biomes.length)];
        }
    }

    private void generateSkyIslands(WorldChunk chunk, int chunkX, int chunkZ, long worldSeed, int worldHeight) {
        int[] islandHeights;
        int minX = chunkX * 16;
        int minZ = chunkZ * 16;
        int[] nArray = islandHeights = new int[]{40, 80, 120, 160, 200};
        int n = islandHeights.length;
        int n2 = 0;
        while (n2 < n) {
            int islandLayer = nArray[n2];
            int lx = 0;
            while (lx < 16) {
                int lz = 0;
                while (lz < 16) {
                    double detailIslandNoise;
                    int wx = minX + lx;
                    int wz = minZ + lz;
                    double islandNoise = this.terrainNoise.noise3D((double)wx * 0.02, (double)wz * 0.02, (double)islandLayer * 0.01);
                    double combined = islandNoise + (detailIslandNoise = this.detailNoise.noise3D((double)wx * 0.08, (double)wz * 0.08, (double)islandLayer * 0.01)) * 0.3;
                    if (combined > 0.3) {
                        int islandThickness = 3 + (int)(combined * 8.0);
                        int baseY = islandLayer - islandThickness / 2;
                        int y = 0;
                        while (y < islandThickness) {
                            int blockY = baseY + y;
                            if (blockY >= 0 && blockY < worldHeight) {
                                if (y == 0) {
                                    chunk.setBlock(lx, blockY, lz, Blocks.getBlockID("dz2:stone"));
                                } else if (y < islandThickness - 1) {
                                    chunk.setBlock(lx, blockY, lz, Blocks.getBlockID("dz2:dirt"));
                                } else {
                                    chunk.setBlock(lx, blockY, lz, Blocks.getBlockID("dz2:grass"));
                                    chunk.setLightDepth(lx, lz, blockY);
                                }
                            }
                            ++y;
                        }
                    }
                    ++lz;
                }
                ++lx;
            }
            ++n2;
        }
    }

    @Override
    public void generateChunk(WorldChunk chunk, int chunkX, int chunkY, int chunkZ, long worldSeed, int chunkSize) {
        int lz;
        Random chunkRandom = new Random(worldSeed + (long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        int minX = chunkX * 16;
        int minY = chunkY * 16;
        int minZ = chunkZ * 16;
        if (this.biomeType == BiomeType.FLAT) {
            int lx = 0;
            while (lx < 16) {
                int lz2 = 0;
                while (lz2 < 16) {
                    int ly = 0;
                    while (ly < 16) {
                        int worldY = minY + ly;
                        if (ly <= 0) {
                            if (RNG.randomInt(1, 3) == 1) {
                                chunk.setBlock(lx, ly, lz2, Blocks.getBlockID("dz2:ruby_block"));
                            } else if (RNG.randomInt(1, 3) == 2) {
                                chunk.setBlock(lx, ly, lz2, Blocks.getBlockID("dz2:iron_block"));
                            } else {
                                chunk.setBlock(lx, ly, lz2, Blocks.getBlockID("dz2:copper_block"));
                            }
                        }
                        ++ly;
                    }
                    chunk.setLightDepth(lx, lz2, 0);
                    ++lz2;
                }
                ++lx;
            }
            return;
        }
        if (this.biomeType == BiomeType.PILLARS) {
            int worldY;
            int ly;
            int lz3;
            int lx = 0;
            while (lx < 16) {
                lz3 = 0;
                while (lz3 < 16) {
                    ly = 0;
                    while (ly < 16) {
                        worldY = minY + ly;
                        if (worldY <= -1) {
                            chunk.setBlock(lx, ly, lz3, 0);
                        } else if (worldY == 0) {
                            chunk.setBlock(lx, ly, lz3, Blocks.getBlockID("dz2:bedrock"));
                        } else if (worldY <= 4) {
                            chunk.setBlock(lx, ly, lz3, Blocks.getBlockID("dz2:dirt"));
                        } else if (worldY == 5) {
                            chunk.setBlock(lx, ly, lz3, Blocks.getBlockID("dz2:grass"));
                        }
                        ++ly;
                    }
                    chunk.setLightDepth(lx, lz3, 0);
                    ++lz3;
                }
                ++lx;
            }
            lx = 0;
            while (lx < 12) {
                lz3 = 0;
                while (lz3 < 12) {
                    ly = 0;
                    while (ly < 16) {
                        worldY = minY + ly;
                        if (worldY >= -1) {
                            chunk.setBlock(lx, ly, lz3, Blocks.getBlockID("dz2:glass"));
                        }
                        ++ly;
                    }
                    chunk.setLightDepth(lx, lz3, 0);
                    ++lz3;
                }
                ++lx;
            }
            return;
        }
        if (this.biomeType == BiomeType.SKY) {
            int lx = 0;
            while (lx < 16) {
                int lz4 = 0;
                while (lz4 < 16) {
                    int ly = 0;
                    while (ly < chunkSize) {
                        chunk.setBlock(lx, ly, lz4, 0);
                        ++ly;
                    }
                    chunk.setLightDepth(lx, lz4, 0);
                    ++lz4;
                }
                ++lx;
            }
            this.generateSkyIslands(chunk, chunkX, chunkZ, worldSeed, chunkSize);
            this.generateClouds(chunk, chunkRandom, chunkX, chunkZ, chunkSize);
            this.generateLowClouds(chunk, chunkRandom, chunkX, chunkZ, chunkSize);
            this.generateTrees(chunk, chunkRandom, minX, minZ, chunkSize);
            this.generateTallGrass(chunk, chunkRandom, minX, minZ, chunkSize);
            this.generateFlowers(chunk, chunkRandom, minX, minZ, chunkSize);
            return;
        }
        if (this.biomeType == BiomeType.SKYGRID) {
            int lx = 0;
            while (lx < 1) {
                int lz5 = 0;
                while (lz5 < 1) {
                    int ly = 0;
                    while (ly < 1) {
                        int worldY = minY + ly;
                        chunk.setBlock(lx, ly, lz5, RNG.randomInt(1, DZ2.getInstance().blockPaintLimit));
                        ++ly;
                    }
                    chunk.setLightDepth(lx, lz5, 0);
                    ++lz5;
                }
                ++lx;
            }
            return;
        }
        int lx = 0;
        while (lx < 16) {
            lz = 0;
            while (lz < 16) {
                int wx = minX + lx;
                int wz = minZ + lz;
                double base = this.terrainNoise.noise3D((double)wx * 0.005, (double)wz * 0.005, 0.0);
                double detail = this.detailNoise.noise3D((double)wx * 0.03, (double)wz * 0.03, 0.0);
                double normalized = (base + detail * 0.4) * 0.5 + 0.5;
                int terrainHeight = (int)(64.0 + (normalized - 0.5) * 80.0);
                terrainHeight = Math.max(8, Math.min(512, terrainHeight));
                int ly = 0;
                while (ly < 16) {
                    int worldY = minY + ly;
                    if (worldY <= 0) {
                        chunk.setBlock(lx, ly, lz, Blocks.getBlockID("dz2:bedrock"));
                    } else if (worldY <= terrainHeight - 4) {
                        chunk.setBlock(lx, ly, lz, Blocks.getBlockID("dz2:stone"));
                    } else if (worldY < terrainHeight) {
                        chunk.setBlock(lx, ly, lz, Blocks.getBlockID("dz2:dirt"));
                    } else if (worldY == terrainHeight) {
                        if (this.biomeType == BiomeType.DESERT) {
                            chunk.setBlock(lx, ly, lz, Blocks.getBlockID("dz2:sand"));
                        } else {
                            chunk.setBlock(lx, ly, lz, Blocks.getBlockID("dz2:grass"));
                        }
                    }
                    ++ly;
                }
                chunk.setLightDepth(lx, lz, terrainHeight);
                ++lz;
            }
            ++lx;
        }
        this.generateCaves(chunk, chunkRandom, minX, minZ, chunkSize);
        this.generateClouds(chunk, chunkRandom, chunkX, chunkZ, chunkSize);
        this.generateTrees(chunk, chunkRandom, minX, minZ, chunkSize);
        this.generateTallGrass(chunk, chunkRandom, minX, minZ, chunkSize);
        this.generateFlowers(chunk, chunkRandom, minX, minZ, chunkSize);
        lx = 0;
        while (lx < 2) {
            lz = 0;
            while (lz < 2) {
                int ly = 0;
                while (ly < 16) {
                    int worldY = minY + ly;
                    chunk.setBlock(lx, ly, lz, RNG.randomInt(1, DZ2.getInstance().blockPaintLimit));
                    ++ly;
                }
                chunk.setLightDepth(lx, lz, 0);
                ++lz;
            }
            ++lx;
        }
    }

    private void generateLowClouds(WorldChunk chunk, Random rand, int chunkX, int chunkZ, int worldHeight) {
        int LOW_CLOUD_MIN_Y = 60;
        int LOW_CLOUD_MAX_Y = 100;
        int lx = 0;
        while (lx < 16) {
            int lz = 0;
            while (lz < 16) {
                int baseY;
                int worldX = chunkX * 16 + lx;
                int worldZ = chunkZ * 16 + lz;
                double noiseValue = this.cloudNoise.noise3D((double)worldX * 0.003, (double)worldZ * 0.003, 100.0);
                double cloudProbability = (noiseValue + 1.0) / 2.0;
                if (rand.nextDouble() < cloudProbability * 0.012 && (baseY = 60 + rand.nextInt(40)) >= 60 && baseY <= 96) {
                    this.generateCloud(chunk, rand, lx, baseY, lz, worldHeight);
                }
                ++lz;
            }
            ++lx;
        }
    }

    private void generateCaves(WorldChunk chunk, Random rand, int worldX, int worldZ, int maxY) {
        int lx = 0;
        while (lx < 16) {
            int lz = 0;
            while (lz < 16) {
                int y = 12;
                while (y < maxY - 20) {
                    double n = this.caveNoise.noise3D((double)(worldX + lx) * 0.1, (double)y * 0.08, (double)(worldZ + lz) * 0.1);
                    if (n < -0.58) {
                        chunk.setBlock(lx, y, lz, 0);
                    }
                    ++y;
                }
                ++lz;
            }
            ++lx;
        }
    }

    private void generateClouds(WorldChunk chunk, Random rand, int chunkX, int chunkZ, int worldHeight) {
        int CLOUD_MIN_Y = 172;
        int CLOUD_MAX_Y = 234;
        int lx = 0;
        while (lx < 16) {
            int lz = 0;
            while (lz < 16) {
                int baseY;
                int worldX = chunkX * 16 + lx;
                int worldZ = chunkZ * 16 + lz;
                double noiseValue = this.cloudNoise.noise3D((double)worldX * 0.0025, (double)worldZ * 0.0025, (double)(worldZ + lz) * 0.1);
                double cloudProbability = (noiseValue + 1.0) / 2.0;
                if (rand.nextDouble() < cloudProbability * 0.008 && (baseY = 172 + rand.nextInt(62)) >= 172 && baseY <= 230) {
                    this.generateCloud(chunk, rand, lx, baseY, lz, worldHeight);
                }
                ++lz;
            }
            ++lx;
        }
    }

    private void generateCloud(WorldChunk chunk, Random rand, int centerLX, int baseY, int centerLZ, int worldHeight) {
        int cloudSize = rand.nextInt(3) + 3;
        int dx = -cloudSize;
        while (dx <= cloudSize) {
            int dz = -cloudSize;
            while (dz <= cloudSize) {
                int dy = 0;
                while (dy <= 1) {
                    int lx = centerLX + dx;
                    int ly = baseY + dy;
                    int lz = centerLZ + dz;
                    if (ly >= 0 && ly < worldHeight && lx >= 0 && lx < 16 && lz >= 0 && lz < 16 && chunk.getBlock(lx, ly, lz) == 0 && rand.nextDouble() > 0.2) {
                        chunk.setBlock(lx, ly, lz, Blocks.getBlockID("dz2:cloud_block"));
                    }
                    ++dy;
                }
                ++dz;
            }
            ++dx;
        }
    }

    private void generateTrees(WorldChunk chunk, Random rand, int worldX, int worldZ, int worldHeight) {
        if (this.biomeType == BiomeType.DESERT) {
            return;
        }
        for (GreatTreeConfig greatTreeConfig : greatTreeConfigs) {
            this.generateGreatTreesInChunk(chunk, rand, worldX, worldZ, worldHeight, greatTreeConfig);
        }
        for (TreeConfig treeConfig : treeConfigs) {
            this.generateRegularTreesInChunk(chunk, rand, worldX, worldZ, worldHeight, treeConfig);
        }
    }

    private void generateRegularTreesInChunk(WorldChunk chunk, Random rand, int worldX, int worldZ, int worldHeight, TreeConfig config) {
        int lx = 2;
        while (lx < 14) {
            int lz = 2;
            while (lz < 14) {
                int surfaceBlock;
                int surfaceY;
                int wx = worldX + lx;
                int wz = worldZ + lz;
                double treeNoiseSample = this.treeNoise.noise3D((double)wx * 0.05 + config.noiseOffset, (double)wz * 0.05 + config.noiseOffset, 0.0);
                double normalizedNoise = (treeNoiseSample + 1.0) / 2.0;
                if (rand.nextDouble() < config.probabilityThreshold && normalizedNoise > 0.4 && (surfaceY = this.getLocalSurfaceY(chunk, lx, lz, worldHeight)) > 0 && surfaceY < worldHeight - 10 && (surfaceBlock = chunk.getBlock(lx, surfaceY, lz)) == Blocks.getBlockID("dz2:grass")) {
                    chunk.setBlock(lx, surfaceY, lz, Blocks.getBlockID("dz2:dirt"));
                    this.generateRegularTree(chunk, rand, lx, surfaceY + 1, lz, worldHeight, config);
                }
                ++lz;
            }
            ++lx;
        }
    }

    private void generateRegularTree(WorldChunk chunk, Random rand, int lx, int baseY, int lz, int worldHeight, TreeConfig config) {
        int trunkHeight = config.minTrunkHeight + rand.nextInt(config.maxTrunkHeight - config.minTrunkHeight + 1);
        if (baseY + trunkHeight + 2 >= worldHeight) {
            return;
        }
        int y = 0;
        while (y < trunkHeight) {
            int blockY = baseY + y;
            if (blockY >= worldHeight) break;
            chunk.setBlock(lx, blockY, lz, config.logBlockID);
            ++y;
        }
        int leafStartY = baseY + trunkHeight - 1;
        int leafX = lx - 1;
        while (leafX <= lx + 1) {
            int leafY = leafStartY;
            while (leafY <= leafStartY + 2) {
                int leafZ = lz - 1;
                while (leafZ <= lz + 1) {
                    if ((Math.abs(leafX - lx) != 1 || Math.abs(leafZ - lz) != 1 || leafY != leafStartY + 2) && leafY >= 0 && leafY < worldHeight && leafX >= 0 && leafX < 16 && leafZ >= 0 && leafZ < 16 && chunk.getBlock(leafX, leafY, leafZ) == 0) {
                        chunk.setBlock(leafX, leafY, leafZ, config.leavesBlockID);
                    }
                    ++leafZ;
                }
                ++leafY;
            }
            ++leafX;
        }
    }

    private void generateGreatTreesInChunk(WorldChunk chunk, Random rand, int worldX, int worldZ, int worldHeight, GreatTreeConfig config) {
        int lx = 3;
        while (lx < 13) {
            int lz = 3;
            while (lz < 13) {
                int surfaceBlock;
                int surfaceY;
                int wx = worldX + lx;
                int wz = worldZ + lz;
                double treeNoiseSample = this.treeNoise.noise3D((double)wx * 0.03 + config.noiseOffset + 100.0, (double)wz * 0.03 + config.noiseOffset + 100.0, 0.0);
                double normalizedNoise = (treeNoiseSample + 1.0) / 2.0;
                if (rand.nextDouble() < config.probabilityThreshold && normalizedNoise > 0.4 && (surfaceY = this.getLocalSurfaceY(chunk, lx, lz, worldHeight)) > 0 && surfaceY < worldHeight - 20 && (surfaceBlock = chunk.getBlock(lx, surfaceY, lz)) == Blocks.getBlockID("dz2:grass")) {
                    int halfWidth = config.trunkWidth / 2;
                    int dx = -halfWidth;
                    while (dx <= halfWidth) {
                        int dz = -halfWidth;
                        while (dz <= halfWidth) {
                            int dirtX = lx + dx;
                            int dirtZ = lz + dz;
                            if (dirtX >= 0 && dirtX < 16 && dirtZ >= 0 && dirtZ < 16) {
                                chunk.setBlock(dirtX, surfaceY, dirtZ, Blocks.getBlockID("dz2:dirt"));
                            }
                            ++dz;
                        }
                        ++dx;
                    }
                    this.generateGreatTree(chunk, rand, lx, surfaceY + 1, lz, worldHeight, config);
                }
                ++lz;
            }
            ++lx;
        }
    }

    private void generateGreatTree(WorldChunk chunk, Random rand, int lx, int baseY, int lz, int worldHeight, GreatTreeConfig config) {
        int leafStartY;
        int trunkHeight = config.minTrunkHeight + rand.nextInt(config.maxTrunkHeight - config.minTrunkHeight + 1);
        if (baseY + trunkHeight + 4 >= worldHeight) {
            return;
        }
        int y = 0;
        while (y < trunkHeight) {
            int blockY = baseY + y;
            if (blockY >= worldHeight) break;
            int dx = 0;
            while (dx < config.trunkWidth) {
                int dz = 0;
                while (dz < config.trunkWidth) {
                    int trunkX = lx + dx;
                    int trunkZ = lz + dz;
                    if (trunkX >= 0 && trunkX < 16 && trunkZ >= 0 && trunkZ < 16) {
                        chunk.setBlock(trunkX, blockY, trunkZ, config.logBlockID);
                    }
                    ++dz;
                }
                ++dx;
            }
            ++y;
        }
        int ly = leafStartY = baseY + trunkHeight - 2;
        while (ly <= leafStartY + 4) {
            if (ly >= 0 && ly < worldHeight) {
                int radius = ly < leafStartY + 2 ? config.maxCanopyRadius : config.minCanopyRadius;
                int leafX = lx - radius;
                while (leafX <= lx + radius + config.trunkWidth - 1) {
                    int leafZ = lz - radius;
                    while (leafZ <= lz + radius + config.trunkWidth - 1) {
                        if ((ly != leafStartY + 4 || Math.abs(leafX - lx) <= 1 || Math.abs(leafZ - lz) <= 1) && leafX >= 0 && leafX < 16 && leafZ >= 0 && leafZ < 16 && chunk.getBlock(leafX, ly, leafZ) == 0) {
                            chunk.setBlock(leafX, ly, leafZ, config.leavesBlockID);
                        }
                        ++leafZ;
                    }
                    ++leafX;
                }
            }
            ++ly;
        }
    }

    private void generateTallGrass(WorldChunk chunk, Random rand, int worldX, int worldZ, int worldHeight) {
        if (this.biomeType == BiomeType.DESERT) {
            return;
        }
        int lx = 0;
        while (lx < 16) {
            int lz = 0;
            while (lz < 16) {
                int aboveBlock;
                int surfaceBlock;
                int surfaceY;
                int wx = worldX + lx;
                int wz = worldZ + lz;
                double noiseValue = this.tallGrassNoise.noise3D((double)wx * 0.2, (double)wz * 0.2, 0.0);
                double tallGrassProbability = (noiseValue + 1.0) / 2.0;
                if (tallGrassProbability > 0.6 && rand.nextDouble() < 0.3 && (surfaceY = this.getLocalSurfaceY(chunk, lx, lz, worldHeight)) >= 0 && surfaceY < worldHeight - 1 && (surfaceBlock = chunk.getBlock(lx, surfaceY, lz)) == Blocks.getBlockID("dz2:grass") && (aboveBlock = chunk.getBlock(lx, surfaceY + 1, lz)) == 0) {
                    chunk.setBlock(lx, surfaceY + 1, lz, Blocks.getBlockID("dz2:tall_grass"));
                }
                ++lz;
            }
            ++lx;
        }
    }

    private void generateFlowers(WorldChunk chunk, Random rand, int worldX, int worldZ, int worldHeight) {
        if (this.biomeType == BiomeType.DESERT) {
            return;
        }
        int lx = 0;
        while (lx < 16) {
            int lz = 0;
            while (lz < 16) {
                int aboveBlock;
                int surfaceBlock;
                int surfaceY = this.getLocalSurfaceY(chunk, lx, lz, worldHeight);
                if (surfaceY >= 0 && surfaceY < worldHeight - 1 && (surfaceBlock = chunk.getBlock(lx, surfaceY, lz)) == Blocks.getBlockID("dz2:grass") && (aboveBlock = chunk.getBlock(lx, surfaceY + 1, lz)) == 0) {
                    int i2 = 0;
                    while (i2 < flowerConfigs.size()) {
                        FlowerConfig flower = flowerConfigs.get(i2);
                        int wx = worldX + lx;
                        int wz = worldZ + lz;
                        double noiseValue = this.flowerNoise.noise3D((double)wx * 0.1 + (double)(i2 * 1000), (double)wz * 0.1 + (double)(i2 * 1000), 0.0);
                        double flowerProbability = (noiseValue + flower.noiseOffset) / 2.0;
                        if (flowerProbability > flower.probabilityThreshold && rand.nextDouble() < 0.3) {
                            chunk.setBlock(lx, surfaceY + 1, lz, flower.blockID);
                            break;
                        }
                        ++i2;
                    }
                }
                ++lz;
            }
            ++lx;
        }
    }

    private int getLocalSurfaceY(WorldChunk chunk, int lx, int lz, int worldHeight) {
        int y = worldHeight - 1;
        while (y >= 0) {
            int id = chunk.getBlock(lx, y, lz);
            if (id != 0 && id != Blocks.getBlockID("dz2:air")) {
                return y;
            }
            --y;
        }
        return -1;
    }
}

